global script_node

local Console1Objects = FindNodeByName("Console1InteractableScript")
local Console2Objects = FindNodeByName("Console2InteractableScript")
local Console3Objects = FindNodeByName("Console3InteractableScript")
local Console4Objects = FindNodeByName("Console4InteractableScript")
local Console5Objects = FindNodeByName("Console5InteractableScript")
local Console6Objects = FindNodeByName("Console6InteractableScript")
local controls = FindNodeByName("AllControlsScript")

local Itemindex = 0

global function SaySequenceStart()
	local doctor = GetActor("doctor")
	
	Itemindex = 1

	SayPrep("skip","")

	--HINT
	--Doctor is ready to start the TARDIS, preamble for the timed run round the console hitting buttons
		doctor::SID_2426:Okay, time to go! I'll have to be quick, we've got 60 seconds to get the TARDIS going or I'll have to start again!

	--HINT
	--Doctor is starting the TARDIS individual instruction, player will do something after each line is spoken.
		doctor::SID_1778:Quick lock the doors!

	--GO! (PART 1 - player goes to 6.2)
	controls.script.ConsoleDV = 6
	controls.script.ControlDV = 2
	controls.script.TurnOnAllConsoles()
end

global function StopAll() 
	FindNodeByName("AmbConsoleDef_1"):StopTrigger()
	FindNodeByName("AmbConsoleDef_2"):StopTrigger()
	FindNodeByName("AmbConsoleDef_3"):StopTrigger()
	FindNodeByName("AmbConsoleDef_4"):StopTrigger()
	FindNodeByName("AmbConsoleDef_5"):StopTrigger()
	FindNodeByName("ConsoleAmbiance"):Wake()
end

global function FailedSequence()
	local doctor = GetActor("doctor")
	local fail = FindNodeByName("fail")
	
	fail:Trigger()
	
	StopAll()
	controls.script.TurnOffControls()
	FindNodeByName("Amy_Interact"):Wake()
	controls.script.TurnOffAllConsoles()
	controls.script.ResetAllControls()	

	SayPrep("skip","")

	--VO 
	--Doctor failes the startup sequence
		doctor::SID_2393:No! too slow, I need to try again and be faster this time.
	
	SaySequenceStart()	
end

global function WrongInteract()
	local doctor = GetActor("doctor")

	controls.script.TurnOffInterface()	

	SayPrep("skip","")	

	if (Itemindex == 1) then
		--VO 
		--Doctor chose wrong interact on launch
			doctor::SID_2522:Oops, wrong control. Door controls are here somewhere.
	elseif (Itemindex == 2) then
		--VO 
		--Doctor chose wrong interact on launch
			doctor::SID_2523:Where is that Atom Accelerator? I'm sure it's on this panel.
	elseif (Itemindex == 3) then
		--VO 
		--Doctor chose wrong interact on launch
			doctor::SID_2524:The Dematerialise Lever is next in the sequence.
	elseif (Itemindex == 4) then
		--VO 
		--Doctor chose wrong interact on launch
			doctor::SID_2525:I need to find those Inertial Dampers, now where are they?
	elseif (Itemindex == 5) then 
		--VO 
		--Doctor chose wrong interact on launch
			doctor::SID_2526:Just one last control before launch, the Space-Time Throttle.
	end
	
	controls.script.TurnOnInterface()
end

global function Completed()
	local doctor = GetActor("doctor")
	
	doctor:SetBehaviour("wait")
	
	FindNodeByName("StartTardis"):Sleep()
	FindNodeByName("AmbConsoleDef_5"):StopTrigger()
	controls.script.TurnOffControls()
	
	--Trigger penultimate cut scene!!!
	FindNodeByName("TardisDemat"):Trigger()
end

global function PowerUpAtomAccelerator()
	local doctor = GetActor("doctor")

	--Hint
	--Doctor is starting the TARDIS individual instruction, player will do something after each line is spoken.
		doctor::SID_1775:Now to power up the Atom Accelerator.
end

local function PanelDone()
	local doctor = GetActor("doctor")

	controls.script.TurnOffControls()
	FindNodeByName("Amy_Interact"):Wake()
	doctor:SetBehaviour("pc")
end

global function CheckFinal()
	local doctor = GetActor("doctor")
	local IncrementCount = 0

	SayPrep("skip","async")
	
	--PART 1) 6.2 Door Lock USED	
	if (Itemindex == 1) then
		if (Console6Objects.script.Object2State == 1) then
			FindNodeByName("StartTardis"):StopTrigger()
			FindNodeByName("StartTardis"):Wake()
			FindNodeByName("StartTardis"):Trigger()
			IncrementCount = 1
			
			--Hint
			--Doctor is starting the TARDIS
				doctor::SID_2388:60 seconds! Pay attention, Pond! You might need to remember all this one day!
			
			SetSayCallback(script_node, "PowerUpAtomAccelerator")
			
			print("Setting dv","\n")
			FindNodeByName("ConsoleAmbiance"):Sleep()
			FindNodeByName("AmbConsoleDef_1"):Trigger()
			FindNodeByName("AllControlsScript").script.ConsoleDV = 2
			FindNodeByName("AllControlsScript").script.ControlDV = 1
			PanelDone()
		else
			WrongInteract()
		end
	--PART 2) 2.1 Atom Accelerator USED
	elseif (Itemindex == 2) then
		if (Console2Objects.script.Object1State == 1) then
			FindNodeByName("AmbConsoleDef_1"):StopTrigger()
			FindNodeByName("AmbConsoleDef_2"):Trigger()
			IncrementCount = 1
				
			--Hint
			--Doctor is starting the tardis, individual instruction, player will do something after each line is spoken.
				doctor::SID_1782:Nearly got it! Pull the Dematerialise Lever.
	
			FindNodeByName("AllControlsScript").script.ConsoleDV = 5
			FindNodeByName("AllControlsScript").script.ControlDV = 5
			PanelDone()
		else
			WrongInteract()
		end
	--PART 3) 5.5 Dematerialise Lever USED
	elseif (Itemindex == 3) then
		if (Console5Objects.script.Object5State == 1) then
			FindNodeByName("AmbConsoleDef_2"):StopTrigger()
			FindNodeByName("AmbConsoleDef_3"):Trigger()
			IncrementCount = 1
		
			--Hint
			--Doctor is starting the tardis, individual instruction, player will do something after each line is spoken.
				doctor::SID_2463:Right, now to Engage the Inertial Dampers.	
			
			FindNodeByName("AllControlsScript").script.ConsoleDV = 3
			FindNodeByName("AllControlsScript").script.ControlDV = 3
			PanelDone()
		else
			WrongInteract()
		end
	--PART 4) 3.3 Interial Dampers USED
	elseif (Itemindex == 4) then
		if (Console3Objects.script.Object3State == 1) then
			FindNodeByName("AmbConsoleDef_3"):StopTrigger()
			FindNodeByName("AmbConsoleDef_4"):Trigger()
			IncrementCount = 1
			
			--Hint
			--Doctor is starting the tardis, individual instruction, player will do something after each line is spoken.
				doctor::SID_1783:And we're off, at last! Pull the Space and Time Throttle to adjust the speed.
			
			FindNodeByName("AllControlsScript").script.ConsoleDV = 1
			FindNodeByName("AllControlsScript").script.ControlDV = 2
			PanelDone()
		else
			WrongInteract()
		end
	--PART 5) 1.2 Space/Time Throttle USED
	elseif (Itemindex == 5) then
		if (Console1Objects.script.Object2State == 1) then
			FindNodeByName("AmbConsoleDef_4"):StopTrigger()
			FindNodeByName("AmbConsoleDef_5"):Trigger()
			IncrementCount = 1
						
			Completed()
		else
			WrongInteract()
		end
	end
	
	if (IncrementCount == 1) then 
		Itemindex = Itemindex + 1
	end
end

